	subroutine vwn(n,ndim,k,kdim,rho,sigma,eps)
c**********************************************************************
c
c   FORTRAN subroutine to generate vector white noise with a diagonal
c   covariance matrix with all diagonal elements equal to rho.
c 
c   Input: n = an integer containing the number of observations.
c          ndim = an integer containing the number of rows of x in the
c                 calling routine.
c          k = an integer containing the number of components of the
c              realization.
c          kdim = an integer containing the number of rows of sigma
c                 in the calling routine.
c          rho = a double precision scalar containing the correlation.
c
c   Output: sigma = a double precision square matrix of dimension k
c                   containing the covariance matrix of x.
c           eps = a double precision matrix of dimension n x k containing
c                 the desired realization.
c
c   Subprograms called: (IMSL) DCHFAC, (IMSL) DRNMVN
c
c   Written: 3/3/99 JLH
c
c**********************************************************************
c
	implicit double precision (a-h,p-z)
	integer n, ndim, k, kdim
	double precision rho, eps(ndim,kdim), sigma(kdim,kdim), cons
c
c   Set covariance matrix (sigma):
c
	do i = 1,k
	do j = 1,k
		if(i.eq.j) then
			sigma(i,j) = 1.0d0
		else
			sigma(i,j) = rho
		endif
	enddo
	enddo
c
c   Use IMSL subroutines.
c
c   The subroutine DCHFAC computes an upper triangular factorization
c   of a real symmetric nonnegative definite matrix.  The result is 
c   returned in the matrix sigma.
c
c   The subroutine DRNMVN generates pseudorandom numbers from a 
c   multivariate normal distribution.  The result is returned in the
c   vector eps.
c
	cons = 100.0d0*DMACH(4)
	call DCHFAC(k,sigma,kdim,cons,irank,sigma,kdim)
	call DRNMVN(n,k,sigma,kdim,eps,ndim)
c
	return
	end